/**************************************************************************************
  $Id: TCPConnector.h 13332 2019-11-11 12:40:25Z Robert $

  Description:
    TCP/IP connector for Hilscher marshaller package

  Changes:
    Date        Description
    -----------------------------------------------------------------------------------
    2009-05-25  initial version

 **************************************************************************************/


#ifndef __TCPCONNECTOR__H
#define __TCPCONNECTOR__H

#include "MarshallerConfig.h"

/*****************************************************************************/
/*! TCP connector information data                                           */
/*****************************************************************************/
typedef struct TCP_CONN_INFOtag
{
  int           fConnected;
  char          szHostname[64];
  char          szIPAddress[15];
  unsigned long ulRxCount;
  unsigned long ulTxCount;

} TCP_CONN_INFO_T;

uint32_t TCPConnectorInit       (const HIL_MARSHALLER_CONNECTOR_PARAMS_T* ptParams, void* pvMarshaller);
uint32_t TCPConnectorInfo       (TCP_CONN_INFO_T* ptTcpInfo);
uint32_t TCPConnectorGetLocalIP (char* pszIPAddress, int iLen);

#endif /* __TCPCONNECTOR__H */